\set max_id :scale
\set batch_size :batch_size
\set full_refresh :full_refresh

BEGIN;
-- Insert new lines for random invoices
INSERT INTO mv_benchmark.invoice_lines (invoice_id, amount, qty)
SELECT
    (random(1, :max_id)),
    (random(1, 10000) / 100.0),
    (random(1, 10))
FROM generate_series(1, :batch_size);
COMMIT;

\if :full_refresh
REFRESH MATERIALIZED VIEW mv_benchmark.invoice_summary;
\endif
